#version 330
#extension GL_EXT_gpu_shader4 : enable
// Shaded Horses_SmoothMod02.fsh by  Ultraviolet

//https://www.shadertoy.com/view/lsXBWl
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.5 //*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

const float M_PI = 3.1415972;

// (half) contour
const vec2 vert[43] = vec2[](vec2(0,-0),
                             vec2(-0.066934,0.073242), 
                             vec2(-0.096244,0.12762), 
                             vec2(-0.066934,0.22177), 
                             vec2(-0.056485,0.33263), 
                             vec2(0.094141,0.38494), 
                             vec2(0.19246,0.44143), 
                             vec2(0.11297,0.52929), 
                             vec2(-0.033483,0.56905), 
                             vec2(-0.056485,0.53974), 
                             vec2(0.043933,0.47909), 
                             vec2(-0.060658,0.40167), 
                             vec2(-0.16735,0.53557), 
                             vec2(-0.094141,0.65271), 
                             vec2(0.077416,0.67992), 
                             vec2(0.14435,0.83265), 
                             vec2(0.24477,0.95607), 
                             vec2(0.30963,1.0439), 
                             vec2(0.1548,1.0544), 
                             vec2(0.0,1), 
                             vec2(0.079487,1.09), 
                             vec2(0.014655,1.1422), 
                             vec2(0.03138,1.2531), 
                             vec2(0.16318,1.2803), 
                             vec2(0.24894,1.3096), 
                             vec2(0.3117,1.3159), 
                             vec2(0.32846,1.364), 
                             vec2(0.36819,1.318), 
                             vec2(0.4456,1.3054), 
                             vec2(0.61923,1.2824), 
                             vec2(0.61506,1.2197), 
                             vec2(0.66527,1.136), 
                             vec2(0.7092,1.092), 
                             vec2(0.70502,1.0649), 
                             vec2(0.63806,0.9749), 
                             vec2(0.48953,0.8452), 
                             vec2(0.4456,0.71758), 
                             vec2(0.54185,0.68409), 
                             vec2(0.64854,0.66319), 
                             vec2(0.62133,0.77196), 
                             vec2(0.74896,0.85775), 
                             vec2(0.88493,0.93096), 
                             vec2(1.0,1.0));


// details (represented as 1 single contour for simplicity)
const vec2 det[197] = vec2[](
                            vec2(0.90106,-0.082627),
                            vec2(1.0248,0.0075632),
                            vec2(0.90311,-0.079755),
                            vec2(0.77286,-0.17864),
                            vec2(0.68331,-0.25935),
                            vec2(0.6938,-0.34666),
                            vec2(0.65268,-0.33832),
                            vec2(0.54527,-0.31598),
                            vec2(0.44902,-0.28249),
                            vec2(0.49295,-0.15487),
                            vec2(0.55592,-0.10055),
                            vec2(0.50339,-0.09118),
                            vec2(0.55527,-0.10103),
                            vec2(0.64418,-0.024416),
                            vec2(0.51365,-0.01939),
                            vec2(0.64148,-0.025166),
                            vec2(0.70729,0.063619),
                            vec2(0.52041,0.056996),
                            vec2(0.70844,0.064794),
                            vec2(0.71262,0.091974),
                            vec2(0.66869,0.1359),
                            vec2(0.52323,0.11563),
                            vec2(0.66969,0.13964),
                            vec2(0.61848,0.21959),
                            vec2(0.51691,0.20233),
                            vec2(0.61918,0.21823),
                            vec2(0.62265,0.28235),
                            vec2(0.44889,0.30528),
                            vec2(0.51704,0.23839),
                            vec2(0.5199,0.15744),
                            vec2(0.52367,0.064497),
                            vec2(0.51128,-0.050781),
                            vec2(0.49314,-0.15332),
                            vec2(0.51149,-0.05024),
                            vec2(0.52346,0.064667),
                            vec2(0.52052,0.15831),
                            vec2(0.51594,0.23975),
                            vec2(0.44902,0.30536),
                            vec2(0.37142,0.31567),
                            vec2(0.37547,0.28106),
                            vec2(0.36137,0.26746),
                            vec2(0.37519,0.28121),
                            vec2(0.37161,0.31791),
                            vec2(0.33188,0.36394),
                            vec2(0.32632,0.34797),
                            vec2(0.34413,0.31933),
                            vec2(0.34757,0.2892),
                            vec2(0.33379,0.26771),
                            vec2(0.34748,0.29045),
                            vec2(0.3442,0.32047),
                            vec2(0.32571,0.34736),
                            vec2(0.31512,0.31584),
                            vec2(0.30578,0.28931),
                            vec2(0.30406,0.26799),
                            vec2(0.32059,0.22776),
                            vec2(0.32034,0.21043),
                            vec2(0.32035,0.22748),
                            vec2(0.26329,0.23816),
                            vec2(0.24109,0.26012),
                            vec2(0.22483,0.24894),
                            vec2(0.23993,0.25952),
                            vec2(0.25707,0.27098),
                            vec2(0.30386,0.26814),
                            vec2(0.30433,0.28921),
                            vec2(0.31554,0.31352),
                            vec2(0.25236,0.30956),
                            vec2(0.1666,0.28025),
                            vec2(0.034805,0.25308),
                            vec2(0.030179,0.22242),
                            vec2(0.077108,0.22381),
                            vec2(0.074181,0.2043),
                            vec2(0.030134,0.22326),
                            vec2(0.018075,0.14218),
                            vec2(0.084837,0.089569),
                            vec2(0.11915,0.097959),
                            vec2(0.082915,0.089903),
                            vec2(-0.0025677,-6.5609e-05),
                            vec2(0.15822,0.054315),
                            vec2(0.31362,0.043885),
                            vec2(0.3884,0.07841),
                            vec2(0.43726,0.15746),
                            vec2(0.38916,0.079136),
                            vec2(0.31305,0.043865),
                            vec2(0.24819,-0.043995),
                            vec2(0.14777,-0.16742),
                            vec2(0.080888,-0.32135),
                            vec2(0.074893,-0.36311),
                            vec2(0.080845,-0.32015),
                            vec2(-0.090715,-0.34736),
                            vec2(-0.16393,-0.4645),
                            vec2(-0.057235,-0.5984),
                            vec2(0.047355,-0.52098),
                            vec2(-0.0099704,-0.48725),
                            vec2(-0.098806,-0.54886),
                            vec2(-0.0094202,-0.48841),
                            vec2(-0.055624,-0.46084),
                            vec2(-0.099665,-0.4635),
                            vec2(-0.055028,-0.46012),
                            vec2(-0.035162,-0.43163),
                            vec2(-0.042237,-0.39288),
                            vec2(-0.033727,-0.43134),
                            vec2(0.11639,-0.47077),
                            vec2(0.19626,-0.55953),
                            vec2(0.21725,-0.49512),
                            vec2(0.19588,-0.55863),
                            vec2(0.097565,-0.61512),
                            vec2(-0.053055,-0.66743),
                            vec2(-0.063505,-0.77829),
                            vec2(-0.092815,-0.87244),
                            vec2(-0.063505,-0.92682),
                            vec2(0.0034248,-1.0038),
                            vec2(0.082915,-0.91383),
                            vec2(0.039776,-0.88191),
                            vec2(-0.037953,-0.95721),
                            vec2(0.040105,-0.8818),
                            vec2(0.015333,-0.86276),
                            vec2(-0.013385,-0.87653),
                            vec2(0.015834,-0.8629),
                            vec2(0.031838,-0.7511),
                            vec2(0.0063407,-0.71769),
                            vec2(0.031542,-0.75074),
                            vec2(0.1666,-0.72348),
                            vec2(0.25236,-0.69417),
                            vec2(0.31512,-0.68789),
                            vec2(0.34387,-0.57387),
                            vec2(0.32896,-0.64211),
                            vec2(0.37161,-0.68582),
                            vec2(0.44902,-0.69837),
                            vec2(0.623,-0.72085),
                            vec2(0.66386,-0.65508),
                            vec2(0.6213,-0.72581),
                            vec2(0.61848,-0.78414),
                            vec2(0.66869,-0.86783),
                            vec2(0.71262,-0.91176),
                            vec2(0.70844,-0.93894),
                            vec2(0.64148,-1.0289),
                            vec2(0.49295,-1.1586),
                            vec2(0.44902,-1.2862),
                            vec2(0.4925,-1.3022),
                            vec2(0.51582,-1.2356),
                            vec2(0.47125,-1.2109),
                            vec2(0.51602,-1.2353),
                            vec2(0.55933,-1.1526),
                            vec2(0.70232,-1.0529),
                            vec2(0.77397,-0.95581),
                            vec2(0.71159,-0.91187),
                            vec2(0.77337,-0.95437),
                            vec2(0.7009,-1.0515),
                            vec2(0.55852,-1.1528),
                            vec2(0.51422,-1.2402),
                            vec2(0.62801,-1.2606),
                            vec2(0.51456,-1.2401),
                            vec2(0.49324,-1.3029),
                            vec2(0.54276,-1.3205),
                            vec2(0.65196,-1.3406),
                            vec2(0.62475,-1.2318),
                            vec2(0.75238,-1.146),
                            vec2(0.88835,-1.0728),
                            vec2(1.0034,-1.0038),
                            vec2(0.93723,-0.92682),
                            vec2(0.90792,-0.87244),
                            vec2(0.93723,-0.77829),
                            vec2(0.94768,-0.66743),
                            vec2(1.0983,-0.61512),
                            vec2(1.1966,-0.55863),
                            vec2(1.1171,-0.47077),
                            vec2(1.0153,-0.44313),
                            vec2(1.1081,-0.51535),
                            vec2(1.0797,-0.56628),
                            vec2(0.97079,-0.62794),
                            vec2(1.0796,-0.5657),
                            vec2(1.1076,-0.51499),
                            vec2(1.0156,-0.44376),
                            vec2(0.97068,-0.43101),
                            vec2(0.94768,-0.46032),
                            vec2(1.0481,-0.52097),
                            vec2(0.9435,-0.59839),
                            vec2(0.83681,-0.46449),
                            vec2(0.75549,-0.50029),
                            vec2(0.66622,-0.48935),
                            vec2(0.75619,-0.4978),
                            vec2(0.83779,-0.46475),
                            vec2(0.90486,-0.34559),
                            vec2(0.80353,-0.33633),
                            vec2(0.91002,-0.34735),
                            vec2(1.08,-0.31943),
                            vec2(1.101,-0.27377),
                            vec2(0.87067,-0.27214),
                            vec2(1.0966,-0.2737),
                            vec2(1.1446,-0.16405),
                            vec2(0.97482,-0.16882),
                            vec2(1.1485,-0.16741),
                            vec2(1.2466,-0.042572),
                            vec2(1.0354,-0.060845),
                            vec2(1.2489,-0.043995),
                            vec2(1.3138,0.043865),
                            vec2(1.1545,0.054315));



// tiles to explore for creating the base shape
const vec2 textureTiles[] = vec2[](vec2(0.0), 
                                   vec2(0.0, 1.0), 
                                   vec2(-1.0, 0.0), 
                                   vec2(-1.0, 1.0));

// tiles to explore for creating the details
const vec2 detailTiles[5] = vec2[](vec2(0.0), 
                                   vec2(0.0,-1.0), 
                                   vec2(0.0,-2.0), 
                                   vec2(1.0,-1.0), 
                                   vec2(-1.0,-1.0));

vec2 PointSegProj(vec2 p, vec2 p0, vec2 p1)
{
    vec2 d = p1 - p0;
        
    float t = clamp(dot(p - p0, d) / dot(d, d), 0.0, 1.0);

    vec2 proj = (1.0-t)*p0 + t*p1;
    
    return proj;
}

float PointSegDistance2(vec2 p, vec2 p0, vec2 p1)
{
    vec2 d = p1 - p0;
    
    float t = clamp(dot(p - p0, d) / dot(d, d), 0.0, 1.0);

    vec2 proj = (1.0-t)*p0 + t*p1;
    
    return dot(proj-p, proj-p);
}

vec2 PointSegDirection(vec2 p, vec2 p0, vec2 p1)
{
    vec2 proj = PointSegProj(p, p0, p1);
    
    return proj-p;
}

float horizontalDistance(vec2 p, vec2 p0, vec2 p1)
{
    if(p.y < min(p0.y, p1.y) || p.y > max(p0.y, p1.y))
        return 100000000.0*sign(p1.y-p0.y);
    
    float h = p.y-p0.y;
    float slope = (p1.x-p0.x)/(p1.y-p0.y);
    float l = p.x-h*slope - p0.x;
    
    return l*sign(p1.y-p0.y);
}

float verticalDistance(vec2 p, vec2 p0, vec2 p1)
{
    if(p.x < min(p0.x, p1.x) || p.x > max(p0.x, p1.x))
        return 100000000.0*sign(p1.x-p0.x);
    
    float h = p.x-p0.x;
    float slope = (p1.y-p0.y)/(p1.x-p0.x);
    float l = p.y-h*slope - p0.y;
    
    return l*sign(p1.x-p0.x);
}


float escherTextureX(vec2 p)
{
    vec2 pp = vec2(mod(p.x+0.5, 1.0)-0.5, mod(p.y,2.0));
    
    float d = 1000.0;
    
    for(int i=0; i<19; ++i)
    	if(abs(horizontalDistance(pp, vert[i], vert[i+1])) < abs(d))
        {
            d = horizontalDistance(pp, vert[i], vert[i+1]);
        }
    
    pp = vec2(mod(p.x+0.5, 1.0)-0.5, mod(p.y-1.0,2.0));
    
    for(int i=0; i<19; ++i)
    	if(abs(horizontalDistance(pp, vert[i], vert[i+1])) < abs(d))
        {
            d = horizontalDistance(pp, vert[i], vert[i+1]);
        }
    
    float val = smoothstep(0.0, 1.0, d/0.05);
    val = d;
    
    
    if(mod(p.x-0.5, 2.0)-1.0 > 0.)
        val = -val;
    
    return val;
}


float escherTextureY(vec2 p)
{
    vec2 pp = vec2(mod(p.x, 2.0), mod(p.y-.5, 1.0)+0.5);
    
    float d = 1000.0;
    for(int i=19; i<vert.length()-1; ++i)
    	if(abs(verticalDistance(pp, vert[i], vert[i+1])) < abs(d))
            d=verticalDistance(pp, vert[i], vert[i+1]);
    

    pp = vec2(mod(p.x-1.0, 2.0), mod(p.y-.5, 1.0)+0.5);
    for(int i=19; i<vert.length()-1; ++i)
    	if(abs(verticalDistance(pp, vert[i], vert[i+1])) < abs(d)) 
            d=verticalDistance(pp, vert[i], vert[i+1]);
    
    float val = smoothstep(0.0, 1.0, d/0.05);
    val = d;
    
    if(mod(p.y-0.5, 2.0)-1.0 > 0.)
        val = -val;
    
    return val;
}


float escherTexture(vec2 p, float pixel_size)
{
    float x = escherTextureX(p);
    float y = escherTextureY(p);
    
    x = smoothstep(-1.0, 1.0, x/pixel_size);
    y = smoothstep(-1.0, 1.0, y/pixel_size);
    
    float d = x+y - 2.0 * x*y;
    
    return d;
}


float escherTextureContour(vec2 p, float linewidth, float pixel_size)
{
    vec2 pp = mod(p,1.0);
    
    float d = 10000000.0;
    for(int i=0; i<vert.length(); ++i)
    {       
        for(int j=0; j<textureTiles.length(); ++j)
        {
            d = min(d, PointSegDistance2(pp+textureTiles[j], vert[i], vert[i+1%vert.length()]));
        }
    }
    
    d = smoothstep(0.0, 1.0, (sqrt(d)-linewidth)/pixel_size);
    
    return d;
}


float escherDetails(vec2 p, float linewidth, float pixel_size)
{
    vec2 pp = mod(p,1.0);
    
    float d = 10000000.0;
    for(int i=0; i<det.length()-1; ++i)
    {
        for(int j=0; j<detailTiles.length(); ++j)
        {
            d = min(d, PointSegDistance2(pp+detailTiles[j], det[i], det[i+1]));
        }
    }
    
    d = smoothstep(0.0, 1.0, (sqrt(d)-linewidth)/pixel_size);
    
    return d;
}

vec3 escherNormal(vec2 p)
{
    vec2 pp = mod(p,1.0);
    
    float d = 10000000.0;
    int i_min, j_min;
    
    float d_temp;
    
    for(int i=0; i<vert.length()-1; ++i)
    {
        
        for(int j=0; j<textureTiles.length(); ++j)
        {
            d_temp = PointSegDistance2(pp+textureTiles[j], vert[i], vert[i+1]);
            if(d_temp < d)
            {
                d = d_temp;
                i_min = i;
                j_min = j;
            }
        }
    }
    
    d = sqrt(d);
    
    vec2 proj = PointSegProj(pp+textureTiles[j_min], vert[i_min], vert[i_min+1]);
    
    vec2 dir = proj-(pp+textureTiles[j_min]);
    
    //float alpha = M_PI/4.0;
    //vec3 n = vec3(dir/d*cos(alpha), sin(alpha));
    vec3 n = normalize(vec3(dir/d, 1.0));
    
    return n;
}




vec3 escherDetailNormal(vec2 p)
{
    vec2 pp = mod(p,1.0);
    
    float d = 10000000.0;
    vec2 dir;
    
    vec2 dir_temp;
    float d_temp;
    
    for(int i=0; i<det.length()-1; ++i)
    {
        
        for(int j=0; j<detailTiles.length(); ++j)
        {
            dir_temp = PointSegDirection(pp+detailTiles[j], det[i], det[i+1]);
            d_temp = length(dir_temp);
            if(d_temp < d)
            {
                d = d_temp;
                dir = dir_temp;
            }
        }
    }
    
    float alpha = M_PI/4.0;
    vec3 n = vec3(dir/d*cos(alpha), sin(alpha));
    
    return n;
}

void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = gl_FragCoord.xy / iResolution.y;
    
    uv -= vec2(0.5* iResolution.x / iResolution.y, 0.5);
    float zoom = 3.5;
    zoom = 5.0*iMouse.x / iResolution.x;
    if(iMouse.x < 5.0)
        zoom = 4.0 + sin(iTime);
    
    uv *= zoom;
    
    float pixel_size = 1.5*zoom/iResolution.y;
    float t = escherTexture(uv, pixel_size);
    
	gl_FragColor = vec4(vec3(t),1.0);
    
    
    float beta = iMouse.y/ iResolution.y * 2.0*M_PI;
    if(iMouse.y < 5.0)
        beta = iTime;
    vec3 lightDir = normalize(vec3(cos(beta), sin(beta), 2.0));
    
    vec3 n = escherNormal(uv);
    vec3 n_det = escherDetailNormal(uv);
    float blend = 0.3;
    n = (1.0-blend)*n + blend*n_det;
    n = n/length(n);
    n = n*vec3(vec2(2.0*t-1.0), 1.0);
    float s = 0.15 + 0.85 * (dot(n, lightDir));
    
    float spec = 0.5;
    float shin = 64.0;
	gl_FragColor = vec4(vec3(0.8, vec2(0.8-0.5*t)) * (0.15 + 0.85*s) + spec * vec3(pow(s, shin)),1.0);

  //  float line = escherTextureContour(uv, 0.002, pixel_size);
  //	gl_FragColor = gl_FragColor*line;
    
    float details = escherDetails(uv, 0.0002, pixel_size);
	gl_FragColor = gl_FragColor*details;
}